// background.js
console.log("Background service worker started");

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  console.log("BG: Received message:", message);

  if (message.action === "post_to_gamble_galaxy") {
    console.log("BG: Starting fetch POST...");

    fetch('https://gamble-galaxy.com/new_post_api.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      credentials: 'include', // <-- send cookies/session
      body: `title=${encodeURIComponent(message.title)}&message=${encodeURIComponent(message.message)}`
    })
    .then(res => {
      console.log("BG: Raw response status:", res.status, "ok:", res.ok);
      return res.json().catch(e => { console.error("BG: JSON parse error", e); return { success: false, error: "Invalid JSON" }; });
    })
    .then(data => {
      console.log("BG: Response from server:", data);
      sendResponse(data);
    })
    .catch(err => {
      console.error("BG: Fetch error:", err);
      sendResponse({ success: false, error: "Fetch failed" });
    });

    return true; // keep channel open for async sendResponse
  }
});
